############################################################################################
## package 'secr'
## RPSV.R
## last changed 2009 01 18, 2009 10 02, 2009 10 07
############################################################################################

RPSV <- function (capthist)
{
    if (inherits (capthist, 'list')) {
        lapply(capthist, RPSV)   ## recursive
    }
    else {

        traps <- traps(capthist)
##        prox  <- detector(traps) == 'proximity'
        prox  <- length(dim(capthist)) > 2
        RPSVx <- function (cx) 
        {
            cx <- abs(cx)  # no special trt for deads
            # not proximity
            x <- traps$x[cx]
            y <- traps$y[cx]
            n <- length(x)
            c(n = n-1, ssx = sum(x^2) - (sum(x))^2/n, ssy = sum(y^2) - (sum(y))^2/n)
        }
        if (prox)
        {   

            w <- capthist != 0   ## 2009 10 07 transform to 0,1
            w <- apply(capthist,1:2,function(x) x * (1:length(x)))
            w <- aperm(w, c(2,1,3))
            temp <- apply(w, 1, RPSVx)
        }
        else temp <- apply(capthist, 1, RPSVx)
        temp <- apply(temp[,temp[1,,drop=F]>0, drop=F], 1, sum)
        temp <- sqrt((temp[2]+temp[3]) / (temp[1]-1))
        attr(temp,'names') <- NULL
        temp
    }
}
############################################################################################

