############################################################################################
## package 'secr'
## esa.R
## last changed 2009 06 29
############################################################################################

esa <- function (object, sessnum = 1, beta = NULL, real = NULL)

# Return vector of 'a' for given g0, sigma, [z (if hazard fn) ] and session
# detectfn is integer code for detection function 0 = halfnormal, 1 = hazard, 2 = exponential
# 'sessnum' is integer index of session (factor level of the 'session' attribute in capthist)
# object must have at least capthist, mask, detectfn 

## strictly doesn't need data, so better to avoid when object not available...
{
    if (inherits(object$capthist, 'list')) capthists <- object$capthist[[sessnum]]
    else capthists <- object$capthist
    if (inherits(object$mask, 'list')) masks <- object$mask[[sessnum]]
    else masks <- object$mask

    if (is.null(beta) & is.null(real)) beta <- object$fit$par

    traps  <- attr(capthists, 'traps')  ## need session-specific traps
    n      <- nrow(capthists)
    s      <- ncol(capthists)
    k      <- length(traps(capthists)$x)  
    m      <- length(masks$x)            ## need session-specific mask...
    cell   <- attr(masks,'area')

    if (n==0) stop(paste('no data in capthist for session',session))
    if (is.null(beta)) {
        if (is.null(real)) stop('Requires real parameter values')
        PIA <- rep(1, n * s * k)
        realparval0 <- matrix(real,nr=1)   ## UNTRANSFORMED 
        ncolPIA <- 1
        details <- list(binomN=0, cutval=0, spherical=FALSE)
    }
    else {
        PIA <- object$design0$PIA[sessnum,,,]
        ncolPIA <- dim(object$design0$PIA)[2]
        realparval0 <- makerealparameters (object$design0, beta, 
            object$parindx, object$link, object$fixed)  # naive 
        details <- object$details
        ## does not yet handle scaling ##
    }

    temp <- .C("integralprw1",  PACKAGE = 'secr',
      as.double(realparval0),
      as.integer(n), 
      as.integer(s), 
      as.integer(k), 
      as.integer(m), 
      as.double(unlist(traps(capthists))), 
      as.double(unlist(masks)), 
      as.integer(nrow(realparval0)),  # rows in lookup  
      as.integer(PIA), # index of nc*,S,K to rows in realparval0
      as.integer(ncolPIA),     # ncol - if CL = n, else 1 or ngrp
      as.double(cell), 
      as.integer(object$detectfn), 
      as.integer(details$binomN),
      as.double(details$cutval),
      as.integer(details$spherical),
      a=double(n),
      resultcode=integer(1)
   )
   if (temp$resultcode == 3) stop ('Groups not implemented in external function integralprw1')
   if (temp$resultcode != 0) stop ('Error in external function integralprw1')
   temp$a
}
############################################################################################

