############################################################################################
## package 'secr'
## sim.secr.R
## Copyright (C) 2009 Murray Efford
## last changed 2009 09 07; 2009 09 19 verify = FALSE; 2009 09 26 remove 'attach'
############################################################################################

simulate.secr <- function (object, nsim = 1, seed = NULL, chat = 1, ...)
## if CL, condition on n? what about distribution of covariates over n?
## locate according to IHP with lambda(X) controlled by f(X|covar), assuming homog Poisson
## i.e. use f(X|covar)/max(f(X|covar)) to reject until meet quota n?
## or f(X, covar | detected)?
## TOO HARD - cf MARK

{

##  check input
    if (!inherits(object,'secr')) stop ('sim.secr requires secr object')
    if (object$CL) stop ('sim.secr not implemented for conditional model')
    if (!all(sapply(object$fixed, is.null))) stop ('sim.secr not implemented for fixed parameters') 
    if (is.null(object$D)) stop('old secr object does not have D')

## setup
    # dim(object$D)[1] is number of mask points
    ngrp <- dim(object$D)[2]  
    nsession <- dim(object$D)[3]
    if (!is.null(object$groups)) {
        ## individual covariates for foundation of g
        di <- disinteraction (object$capthist, object$groups)      
    }
    ## we will grow this list - inefficient for very large nsim
    sesscapt <- list()

    ##################
    ## set random seed
    ## copied from simulate.lm
    if (!exists(".Random.seed", envir = .GlobalEnv, inherits = FALSE)) 
        runif(1)
    if (is.null(seed)) 
        RNGstate <- get(".Random.seed", envir = .GlobalEnv)
    else {
        R.seed <- get(".Random.seed", envir = .GlobalEnv)
        set.seed(seed)
        RNGstate <- structure(seed, kind = as.list(RNGkind()))
        on.exit(assign(".Random.seed", R.seed, envir = .GlobalEnv))
    }
    ##################

## loop over replicates
    for (i in 1:nsim) {
        sesspopn <- list()
        for (sessnum in 1:nsession) {
            if (nsession==1) mask <- object$mask
            else mask <- object$mask[[sessnum]]
            popn <- list()
            for (g in 1:ngrp) {
                density <- object$D[,g,sessnum]
                if (chat > 1)
                    density <- density / chat 
                popn[[g]] <- sim.popn (D = density, core = mask, model2D = 'IHP')
                ## following line replaces any previous individual covariates
                ## ---groups only---
                if (!is.null(object$groups)) {
                    covariates(popn[[g]]) <- di[rep(g, nrow(popn[[g]])),]
                }
            }
            sesspopn[[sessnum]] <- rbind.popn(popn)   ## combine groups in one popn object   
        }
        sesscapt[[i]] <- sim.detect(object, object$fit$par, sesspopn) 

        ## experimental
        if (chat>1) 
            sesscapt[[i]] <- replicate (sesscapt[[i]], chat)
    }
    attr(sesscapt,'seed') <- RNGstate   ## save random seed
    class(sesscapt) <- c('list', 'secrdata')
    sesscapt
}
############################################################################################

sim.secr <- function (object, nsim = 1, 
    extractfn = function(x) c(deviance=deviance(x), df=df.residual(x)), 
    seed = NULL, data = NULL, tracelevel = 1, hessian = 'none', 
    start = object$fit$par)  {

## parametric bootstrap simulations based on a fitted secr object
## extractfn is a required function to extract values from an secr fit
## it should return a vector of named values that does not vary in length
## 'hessian' overrides value in object$details
## set hessian='auto' if extractfn requires variance-covariance matrix

    cl   <- match.call(expand.dots = TRUE)
    cl <- paste(names(cl)[-1],cl[-1], sep=' = ', collapse=', ' )
    cl <- paste('sim.secr(', cl, ')')

    if (is.null(extractfn)) extractfn <- trim
    test <- extractfn(object)
 
   if (is.numeric(test)) {
        n.extract <- length(test)
        if (n.extract<=0) stop ('invalid extractfn in sim.secr')
    }

    detectnames <- names(object$design0[[1]])   ## names of real detection parameters
    details <- replace(object$details, 'hessian', hessian)
    tracelevel <- as.integer(tracelevel)
    details$trace <- tracelevel > 1
    min.detections <- 1
    i <- 0

    if (detector(traps(object$capthist)) == 'single') {
        memo ('multi-catch likelihood used for single-catch traps', tracelevel>0)
    }

    if (is.null(data)) {
        memo ('sim.secr simulating detections...', tracelevel>0)
        data <- simulate(object, nsim = nsim, seed = seed)
    } 
    else {
        if (any(class(data) != c('list','secrdata')))
            stop('invalid data')
    }

    fitmodel <- function (sc) { 
        i <<- i+1     
        memo (paste('sim.secr fitting replicate',i,'...'), tracelevel>0)
        nc <-  sum(counts(sc)$'M(t+1)'[,'Total'])
        if (nc >= min.detections) {  
            tempfit <- suppressWarnings( secr.fit(sc, model = object$model, mask = object$mask, 
                CL = object$CL, detectfn = object$detectfn, start = start, link = object$link, 
                fixed = object$fixed, timecov = object$timecov, sessioncov = object$sessioncov, 
                groups = object$groups, dframe = object$dframe, details = details, 
                method = object$fit$method, verify = FALSE) )
            extractfn(tempfit)
        } 
        else if (is.list(test)) list() else rep(NA, n.extract)
    }
   
    if (is.numeric(test)) {
        output <- data.frame(t(sapply (data, fitmodel)))
    }
    else {
        output <- lapply (data, fitmodel)
        class(output) <- c('list','secrlist')
    }

    attr(output,'seed') <- attr(data,'seed')
    attr(output,'call') <- cl
    attr(output,'extractfn') <- extractfn
    output
}
############################################################################################

print.secrdata <- function(x,...) { 
## suggestion of Rolf Turner 19 Jan 2009 for printing without attributes
    attributes(x) <- NULL 
    print(x) 
} 
############################################################################################

print.secrlist <- function(x,...) { 
## suggestion of Rolf Turner 19 Jan 2009 for printing without attributes
    attributes(x) <- NULL 
    print(x) 
} 
############################################################################################

sim.detect <- function (object, beta, popnlist, renumber = TRUE)
## popnlist is always a list of popn objects
{
## suppressed 2009 09 26 to avoid compilation warning messages
##    attach(object, warn.conflicts = FALSE)
##    on.exit(detach())

    Markov <- 'B' %in% object$vars

    dummycapthist<- function (capthist, pop, fillvalue=1) {
        if (inherits(capthist, 'list')) {
            output <- list()
            for (i in 1:nsession) 
                output[[i]] <- dummycapthist (capthist[[i]], 
                    fillvalue = fillvalue, pop=pop[i])         
            class(output) <- c('list','capthist')
            output
        }
        else { 
            newdim <- dim(capthist)
            newdim[1] <- nrow(pop[[1]])
            output <- array(fillvalue, dim = newdim)
            class(output) <- 'capthist'
            traps(output) <- traps(capthist)
            session(output) <- session(capthist)
            covariates(output) <- covariates(pop[[1]])
            output
        }
    }

    ## setup
    MS <- inherits(object$capthist,'list')
    N <- sapply(popnlist, nrow) 

    sessionlevels <- session(object$capthist)   ## was names(capthist) 2009 08 15
    nsession <- length(sessionlevels)

    ## design matrices etc.
    dummyCH <- dummycapthist(object$capthist, popnlist, fillvalue = 0) 
    design0 <- secr.design.MS (dummyCH, object$model, object$timecov, object$sessioncov, object$groups, object$dframe)
    realparval0 <- makerealparameters (design0, beta, object$parindx, object$link, object$fixed)  # naive 

    if ('b' %in% object$vars) {
        dummyCH <- dummycapthist(object$capthist, popnlist, fillvalue = 1) 
        design1 <- secr.design.MS (dummyCH, object$model, object$timecov, object$sessioncov, object$groups, object$dframe)   
        realparval1 <- makerealparameters (design1, beta, object$parindx, object$link, object$fixed)  # caught before
    }
    else {   ## faster
        design1 <- design0
        realparval1 <- realparval0
    }

    output <- list()

    for (sessnum in 1:nsession) {

        ## in multi-session case must get session-specific data from lists
        if (MS) {
            session.capthist <- object$capthist[[sessnum]]
            session.traps    <- traps(object$capthist)[[sessnum]]
        }
        else {
            session.capthist <- object$capthist
            session.traps    <- traps(object$capthist)
        } 

        if (nrow(session.capthist)==0) stop(paste('no data for session',sessnum))
        nc   <- nrow(session.capthist)
        s    <- ncol(session.capthist)

        dettype <- switch (detector(session.traps), multi = 0, proximity = 1, 
            single = 2, count = 3, areasearch = 4, -1)     

        ## detector-specific behaviour

        if (dettype == -1) 
            stop (paste('detector type', detector(session.traps), 'not implemented'))
    
        ## counts
        if (dettype == 3) {
            binomN <- attr(session.traps, 'binomN')   # 0 for Poisson, >0 for binomial
            if (is.null(binomN)) stop ('Count detectors must have attribute binomN', call.=F)
            if (binomN < 0) {
                binomN <- 0
                warning ("Invalid number of binomial trials; using Poisson instead")
            }
        }
        else binomN <- 0

        # area search
        if (dettype == 4) {   
            if (is.null(attr(session.traps,'spacing'))) stop ('Cell spacing required')
            searchcell <- attr(session.traps,'spacing')^2 * 0.0001
        }
        else searchcell <- 0    # for proximity

        # signal strength
        if (dettype == 10) {    
            session.capthist <- switch( object$details$tx, 
                log = ifelse( session.capthist == 0, -1e20, log(session.capthist)),
                logit = ifelse( session.capthist == 0, -1e20, logit(session.capthist)),
                identity = ifelse( session.capthist == 0, -1e20, session.capthist)
            )
        }

        k     <- nrow(session.traps)
        trps  <- unlist(session.traps, use.names=F) 
        sessg <- min (sessnum, design1$R)
        session.animals <- unlist(popnlist[[sessnum]])

        #------------------------------------------
        # allow for scaling of detection parameters 

        Xrealparval1  <- realparval1
        Xrealparval0 <- realparval0
        ## D assumed constant over mask, groups
        sigmaindex <- 2
        g0index <- 1
        if (object$details$scalesigma) {   ## assuming previous check that scalesigma OK...
            Xrealparval1[,sigmaindex] <- Xrealparval1[,sigmaindex] / D[1,1,sessnum]^0.5
            Xrealparval0[,sigmaindex] <- Xrealparval0[,sigmaindex] / D[1,1,sessnum]^0.5
        }
        if (object$details$scaleg0)    {   ## assuming previous check that scaleg0 OK...
            Xrealparval1[,g0index] <- Xrealparval1[,g0index] / Xrealparval1[,sigmaindex]^2
            Xrealparval0[,g0index] <- Xrealparval0[,g0index] / Xrealparval0[,sigmaindex]^2
        }
        #------------------------------------------

        ## simulate this session...

        used <- unlist(usage(session.traps))
        if (is.null(used)) used <- rep(1,s*k) 

        NR <- N[sessnum]

        temp <- .C('simsecr', PACKAGE = 'secr',
            as.integer(dettype), 
            as.double(Xrealparval0), 
            as.double(Xrealparval1),
            as.integer(nrow(Xrealparval0)),                # number of rows in lookup table, naive 
            as.integer(nrow(Xrealparval1)),                # ditto, caught before
            as.integer(design0$PIA[sessg,1:NR,1:s,1:k]),   # index of N,S,K to rows in Xrealparval0
            as.integer(design1$PIA[sessg,1:NR,1:s,1:k]),   # index of N,S,K to rows in Xrealparval1
            as.integer(N[sessnum]),
            as.integer(s), 
            as.integer(k), 
            as.double(session.animals), 
            as.double(trps), 
            as.integer(used),
            as.integer(Markov),
            as.integer(binomN),                            # count detector
            as.double(searchcell),                         # area searched per 'detector'
            as.integer(object$detectfn), 
            n = integer(1),
            caught = integer(NR),
            value = integer(NR*s*k),
            resultcode = integer(1)
        )
        
        if (temp$resultcode != 0) 
            stop (paste('simulated detection failed, code ', temp$resultcode))

        if (dettype %in% c(0,2)) {
            w <- array(dim=c(temp$n, s), dimnames = list(NULL,1:s))
            if (temp$n>0)  w[,] <- round(temp$value[1:(temp$n*s)])
        }
        else {
            w <- array(dim=c(temp$n, s, k), dimnames = list(NULL,1:s,NULL))
            if (temp$n>0)  w[,,] <- round(temp$value[1:(temp$n*s*k)])
        }

        class(w)    <- 'capthist'    # NOT data.frame
        traps(w)    <- session.traps
        session(w)  <- sessionlevels[sessnum]

        if (!is.null(covariates(popnlist))) {
            covariates(w) <- subset(covariates(popnlist[[sessnum]]), subset = 
                as.logical(temp$caught))
        }

        if (MS) 
            attr(w, 'cut') <- attr(object$capthist[[sessnum]],'cut')
        else 
            attr(w, 'cut') <- attr(object$capthist,'cut')

        if (renumber & (temp$n>0)) rownames(w) <- 1:temp$n
        else rownames(w)          <- (1:N[sessnum])[as.logical(temp$caught)]       
        output[[sessnum]] <- w      
    }

    if (nsession==1) output <- output[[1]] 
    else {
        names(output) <- sessionlevels
        class(output) <- c('list','capthist')
    }
    output
}
############################################################################################

