############################################################################################
## package 'secr'
## write.capthist.R
## last changed 2009 03 30, 2009 06 11, 2009 07 08
## Write capture histories to text file in DENSITY format
############################################################################################

write.capthist <- function (object, file='', ..., deblank = TRUE, header = TRUE, sess = '1') 

{
    objectname <-  deparse(substitute(object), control=NULL)

    if (!is(object, 'capthist')) stop ('write.capthist requires a capthist object')

    if (inherits(object, 'list')) {
        lapply (object, write.capthist, file = file, deblank = deblank, 
            header = FALSE, ...)  ## not finished
    }
    else {
        n <- nrow(object)
        S <- ncol(object)
        if (detector(traps(object)) %in% c('proximity','counts','signal')) {
            K <- dim(object)[3]
            trap <- rep(1:K, rep(n*S, K))
            OK <- as.numeric(object) != 0
        }
        else  {
            K <- 1
            trap <- as.numeric(object)
            OK <- abs(trap) > 0
        }
    
        trap <- row.names(traps(object))[trap]
        if (deblank) trap <- gsub(' ', '', trap)
    
        session <- rep(sess, n*S*K)[OK]                      ## assumes 1 session 
        ID <- rep( 1:n, S*K )[OK]
        occ <- rep (rep (1:S, K), rep(n, S*K))[OK]
    
        temp <- data.frame (session=session, ID=ID, occ=occ, trap=trap)
    
        if (header) {
            cat ("; Capture histories exported from '", objectname, "' \n", sep="", file=file)
            cat (';', format(Sys.time(), "%a %b %d %X %Y"), '\n', append = TRUE, file=file)
            cat (';\n', append = TRUE, file=file)
            cat ('; Session ID Occasion Detector\n', append = TRUE, file=file)
        }
    
        write.table(temp, file = file, append = TRUE, 
            row.names = FALSE, col.names = FALSE, quote = FALSE, ...)
    }
}
############################################################################################

