############################################################################################
## package 'secr'
## write.traps.R
## last changed 2009 06 11
## Write detector locations to text file in DENSITY format
############################################################################################

write.traps <- function (object, file='', ..., deblank = TRUE) {
    objectname <-  deparse(substitute(object), control=NULL)

    if (!is(object, 'traps')) stop ('write.traps requires a traps object')
    n <- nrow(object)
    if (detector(object) %in% c('proximity','counts','signal')) {
    }

    # purge blanks from names
    if (deblank) row.names(object) <- gsub(' ','',row.names(object))

    # should remove conflict between row and ...

    cat ("; Detector locations exported from '", objectname, "' \n", sep="", file=file)
    cat (';', format(Sys.time(), "%a %b %d %X %Y"), '\n', append = TRUE, file=file)
    cat (';\n', append = TRUE, file=file)
    cat ('; Detector x y\n', append = TRUE, file=file)

    write.table(object, file = file, append = TRUE, 
        row.names = TRUE, col.names = FALSE, quote = FALSE, ...)
}
############################################################################################

