\name{make.capthist}
\alias{make.capthist}

\title{ Construct capthist Object }

\description{
  Form a \code{capthist} object from a data frame of capture records and a \code{traps} object.
}

\usage{
make.capthist(captures, traps, fmt = "trapID", noccasions = NULL,
    covnames = NULL, bysession = TRUE, sortrows = TRUE, cut = NULL)
}

\arguments{
  \item{captures}{ dataframe of capture records in one of two possible formats (see Details) }
  \item{traps}{ object of class \code{traps} describing an array of passive detectors }
  \item{fmt}{ character string for capture format. Valid values are 'XY' and 'trapID'. }
  \item{noccasions}{ number of occasions on which detectors were operated }
  \item{covnames}{ character vector of names to use for covariate fields if present }
  \item{bysession}{ logical, if true then ID are made unique by session }
  \item{sortrows}{ logical, if true then rows are sorted in ascending order of animalID }
  \item{cut}{ argument not used in \pkg{secr} 1.2 }
}

\details{

\code{make.capthist} is the recommended way to prepare data for
\code{secr.fit}. Each row of the input data frame represents a detection
on one occasion. The capture data frame may be formed from a text file
with \code{read.captures}. 

Input formats are based on the Density software (Efford 2007). If
\code{fmt} = 'XY' the required fields are (session, ID, occasion, x, y)
in that order. If \code{fmt} = 'trapID' the required fields are
(session, ID, occasion, trap), where \code{trap} is the numeric index of
the relevant detector in \code{traps}. \code{session} and \code{ID} may
be character-, vector- or factor-valued; other required fields are
numeric. Fields are matched by position (column number), \emph{not} by
name. Columns after the required fields are interpreted as individual
covariates that may be continuous (e.g., size) or categorical (e.g., age, sex). 

If \code{captures} has data from multiple sessions then \code{traps} may
be either a list of \code{traps} objects, one per session, or a single
\code{traps} object that is assumed to apply throughout. Similarly,
\code{noccasions} may be a vector specifying the number of occasions in
each session.

Covariates are assumed constant for each individual; the first
non-missing value is used. The length of \code{covnames} should equal the
number of covariate fields in \code{captures}.

\code{bysession} takes effect when the same individual is detected in
two or more sessions: TRUE results in one capture history per session,
FALSE has the effect of generating a single capture history (this is not
appropriate for the models currently provided in \pkg{secr}).

Deaths are coded as negative values in the occasion field of
\code{captures}. Occasions should be numbered 1, 2, ..., noccasions. By
default, the number of occasions is the maximum value of 'occasion' in
\code{captures}.

}

\value{

An object of class \code{\link{capthist}} (a matrix or array of
detection data with attributes for detector positions etc.). For
'single' and 'multi' detectors this is a matrix with one row per animal
and one column per occasion (dim(capthist)=c(nc,noccasions)); each
element is either zero (no detection) or a detector number (the row
number in \code{traps} \emph{not} the row name). For 'proximity'
detectors \code{capthist} is an array of values \{-1, 0, 1\} and
dim(capthist)=c(nc,noccasions,ntraps). The number of animals \code{nc}
is determined from the input, as is \code{noccasions} if it is not specified.
\code{traps}, \code{covariates} and other data are retained as
attributes of \code{capthist}. 

Deaths during the experiment are represented as negative values in \code{capthist}. 

If the input has data from multiple sessions then the output is an
object of class c('list','capthist') comprising a list of single-session
\code{capthist} objects.

}

\note{

\code{make.capthist} requires that the data for \code{captures} and
\code{traps} already exist as \R objects. To read data from external
(text) files, first use \code{read.captures} and \code{read.traps}. 

}

\references{ 

Efford, M. G. (2007) \emph{Density 4.1: software for spatially explicit
capture--recapture}. Department of Zoology, University of Otago,
Dunedin, New Zealand. \url{http://www.otago.ac.nz/density}.

}

\author{ Murray Efford \email{murray.efford@otago.ac.nz} }

\seealso{ \code{\link{capthist}}, \code{\link{traps}}, \code{\link{read.captures}}, \code{\link{secr.fit}}, \code{\link{sim.capthist}} }

\examples{

## load demonstration data and peek at XY data
data(rawdata)
captXY[1:5,]  
trapXY[1:5,]  

demotraps <- read.traps(data = trapXY)   
demoCHxy  <- make.capthist (captXY, demotraps, fmt = 'XY')

demoCHxy            ## print method for capthist
plot(demoCHxy)      ## plot method for capthist
summary(demoCHxy)   ## summary method for capthist
}

\keyword{ models }
