\name{make.traps}
\alias{make.grid}
\alias{make.circle}

\title{ Build Detector Array }

\description{
  Construct a rectangular array of detectors (trapping grid) or a circle of detectors.
}

\usage{
make.grid(nx = 6, ny = 6, spacing = 20, detector = "multi", binomN = 0,
    originxy = c(0,0), hollow = F, ID = 'alphay')

make.circle (n = 20, radius = 100, spacing = NULL, 
    detector = "multi", originxy = c(0,0), IDclockwise = T)

}

\arguments{
  \item{nx}{ number of columns of detectors }
  \item{ny}{ number of rows of detectors }
  \item{spacing}{ distance between adjacent detectors (nominally in metres)}
  \item{detector}{ character value for detector type 'single', 'multi' or 'proximity' }
  \item{binomN}{ maximum value when detector == 'count' }
  \item{originxy}{ vector origin for x-y coordinates }
  \item{hollow}{ logical for hollow grid }
  \item{ID}{ character string to control row names }
  \item{n}{ number of detectors }
  \item{radius}{ radius of circle  (nominally in metres) }
  \item{IDclockwise}{ logical for numbering of detectors }
}

\details{

\code{make.grid} generates coordinates for \code{nx.ny} traps at
separation \code{spacing}. The bottom-left (southwest) corner is at
\code{originxy}. For a hollow grid, only detectors on the perimeter are
retained. By default, identifiers are constructed from a letter code for
grid rows and an integer value for grid columns ('A1', 'A2',...).
'Hollow' grids are always numbered clockwise in sequence from the
bottom-left corner. Other values of \code{ID} have the following
effects:

  \tabular{ll}{
     ID \tab Effect \cr
     numx \tab column-dominant numeric sequence \cr
     numy \tab row-dominant numeric sequence \cr
     numxb \tab column-dominant boustrophedonical numeric sequence (try it!) \cr
     numyb \tab row-dominant boustrophedonical numeric sequence \cr
     alphax \tab column-dominant alphanumeric \cr
     alphay \tab row-dominant alphanumeric \cr
  }

  \code{make.circle} generates coordinates for n traps in a circle centred on \code{originxy}.  If \code{spacing} is specified then it overrides the \code{radius} setting; the radius is adjusted to provide the requested straightline distance between adjacent detectors.
  Traps are numbered from the trap due east of the origin, either clockwise or anticlockwise as set by \code{IDclockwise}. 
}

\value{
  An object of class \code{traps} comprising a data frame of x- and y-coordinates, the detector type ('single', 'multi', or 'proximity'), and possibly other attributes.
}

\references{ 

Efford, M.G. (2007) \emph{Density 4.1: software for spatially explicit
capture--recapture}. Department of Zoology, University of Otago,
Dunedin, New Zealand. \url{http://www.otago.ac.nz/density}

Efford, M. G., Borchers D. L. and Byrom, A. E. (2009) Density estimation
by spatially explicit capture-recapture: likelihood-based methods. In:
D. L. Thomson, E. G. Cooch and M. J. Conroy (eds) \emph{Modeling
Demographic Processes in Marked Populations}. Springer, New York. Pp.
255--269.

}

\author{ Murray Efford \email{murray.efford@otago.ac.nz} }

\seealso{ \code{\link{read.traps}}, \code{\link{print.traps}}, \code{\link{plot.traps}}, \code{\link{traps}} }

\note{ Several methods are provided for manipulating detector arrays - see \code{\link{traps}}.

}

\examples{
demo.traps <- make.grid()
plot(demo.traps)

## compare numbering schemes
par (mfrow = c(2,4), mar = c(1,1,1,1), xpd = TRUE)
for (id in c('numx', 'numy', 'alphax', 'alphay', 'numxb', 
    'numyb'))
{
    temptrap <- make.grid(nx = 7, ny = 5, ID = id)
    plot (temptrap, border = 10, lab = TRUE, offset = 7, 
        gridl = FALSE)
}

temptrap <- make.grid(nx = 7, ny = 5, hollow = TRUE)
plot (temptrap, border = 10, lab = TRUE, gridl = FALSE)

plot(make.circle(n = 20, spacing = 30), lab = TRUE, offset = 9)
summary(make.circle(n = 20, spacing = 30))


}

\keyword{ datagen }

