\name{plot.secr}
\alias{plot.secr}
\alias{detectfnplot}

\title{ Plot Detection Functions }

\description{
  Plot detection functions using estimates of parameters in an secr object, or as provided by the user.
}

\usage{
\method{plot}{secr}(x, newdata = NULL, add = FALSE, 
    sigmatick = FALSE, rgr = FALSE, limits = TRUE, alpha = 0.05,
    xval = 0:200, ylim = NULL, xlab = 'Distance  (m)', 
    ylab = 'Detection probability', ...) 

detectfnplot(detectfn, pars, details = NULL, add = FALSE, 
    sigmatick = FALSE, rgr = FALSE, xval = 0:200, ylim = NULL, 
    xlab = 'Distance  (m)', ylab = 'Detection probability', ...) 

}

\arguments{

  \item{x}{ an \code{secr} object }
  \item{newdata}{ dataframe of data to form estimates }
  \item{add}{ logical to add curve(s) to an existing plot }
  \item{sigmatick}{ logical; if TRUE the scale parameter sigma is shown by a vertical line }
  \item{rgr}{ logical; if TRUE a scaled curve r.g(r) is plotted instead of g(r) }
  \item{limits}{ logical; if TRUE pointwise confidence limits are drawn }
  \item{alpha}{ alpha level for confidence intervals }
  \item{xval}{ vector of distances at for which detection to be plotted }
  \item{ylim}{ vector length 2 giving limits of y axis }
  \item{xlab}{ label for x axis }
  \item{ylab}{ label for y axis }
  \item{\dots}{ arguments to pass to \code{lines} }

  \item{detectfn}{ integer code for detection function 0 halfnormal, 1 hazard-rate etc. }
  \item{pars}{ vector or matrix of parameter values }
  \item{details}{ list of ancillary parameters }

}
\details{

\code{newdata} is usually NULL, in which case one curve is plotted for
each session and group. Otherwise, \code{predict.secr} is used to form
estimates and plot a curve for each row in \code{newdata}.

\code{detectfnplot} is an alternative in which the user nominates the
type of function and provides parameter values. If pars is a matrix then
a separate curve is plotted with the parameter values in each row.

For \code{detectfnplot} the signal threshold parameters 'cut' and
'spherical' should be provided in \code{details} (see examples).

Approximate confidence limits for g(r) are calculated using a numerical
first-order delta-method approximation to the standard error at each
\code{xval}. The distribution is assumed to be normal on the logit scale;
limits are back-transformed from that scale.

}

\value{

\code{plot.secr} invisibly returns a dataframe of the plotted values (or
a list of dataframes in the case that \code{newdata} has more than one
row).

}

\author{ Murray Efford \email{murray.efford@otago.ac.nz} }

\seealso{ \code{\link{detection functions}}, \code{\link{plot}}, \code{\link{secr}} }

\examples{

data(secrdemo)
plot (secrdemo.b, xval = 0:100, ylim = c(0, 0.4))
## Add recapture probability
plot (secrdemo.b, newdata = data.frame(b = 1), add = TRUE,
    col='red')

## signal strength detection: 70dB at source, attenuation 
## 0.3dB/m, sdS 5dB; detection threshold 40 dB.
detectfnplot (detectfn = 10, c(70, -0.3, 5), details = 
    list(cut = 40, spherical = FALSE))

## add a function with louder source and spherical spreading...
detectfnplot (detectfn = 10, c(110, -0.3, 5), details = 
    list(cut = 40, spherical = TRUE), add = TRUE, col='red')

}

\keyword{ hplot }

