\name{reduce.capthist}
\alias{reduce.capthist}

\title{ Combine Occasions }

\description{
Combine columns (occasions) in a \code{capthist} object to create a new data set.  Where the input data allow only one observation per occasion (detector types 'single' and 'multi') the pooled data may optionally be treated as if from a 'proximity' detector (i.e. multiple observations per individual per occasion).
}

\usage{
\method{reduce}{capthist}(object, columns, \dots, outputdetector = NULL, random = TRUE)
}

\arguments{
  \item{object}{ \code{capthist} object }
  \item{columns}{ list in which each component is a vector of subscripts for occasions to be pooled }
  \item{\dots}{ other arguments (not used currently) }
  \item{outputdetector}{ character value giving detector type for output }
  \item{random}{ logical for resolution of conflicts }
}

\details{
The first component of \code{columns} defines the columns of \code{object} for new occasion 1, the second for new occasion 2, etc. Ambiguity is possible in the pooled data; this is resolved by retaining only the first detection on any pooled (new) occasion (or a random selection if \code{random} = TRUE). Usage data in the \code{traps} attribute are also pooled if present; a trap is considered 'used' on a pooled occasion if it was used on any contributing occasion.
\code{outputdetector} defaults to the detector type of the input. 

With trap detectors, reducing capture occasions can result in locational ambiguity for individuals caught more than one occasion. By default, these are resolved by choosing one location at random; otherwise (random = FALSE) the first is used. \code{outputdetector} = 'single' is not allowed because of the large potential for conflicts.
}

\value{
An object of class \code{capthist} with number of columns equal to \code{length(occasions)}.  The detector type is inherited from \code{x} unless a new type is specified with the argument \code{outputdetector}.
}

\author{ Murray Efford \email{murray.efford@otago.ac.nz} }

\seealso{ \code{\link{capthist}}, \code{\link{subset.capthist}} }

\examples{
tempcapt <- sim.capthist (make.grid(nx = 6, ny = 6), nocc = 6)
class(tempcapt)

pooled.tempcapt <- reduce(tempcapt, col = list(1,2:3,4:6))
summary (pooled.tempcapt)
}

\keyword{ manip }

