/* functions to be exported */
void integralprw1 (
  double *gsb0val,    /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) [naive animal] */
  int    *nc,       
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *mm,         /* number of points on mask */
  double *traps,      /* x,y locations of traps (first x, then y)  */
  double *mask,       /* x,y points on mask (first x, then y)  */
  int    *cc0,        /* number of g0/sigma/b combinations [naive animal] */
  int    *gsb0,       /* lookup which g0/sigma/b combination to use for given n, S, K [naive animal] */
  int    *ncol,       /* number of columns in gsb0; added 2009 06 25 */
  double *area,       /* area associated with each mask point (ha)  */
  int    *fn,         /* code 0 = halfnormal, 1 = hazard, 10 = signal strength, 11 = binary signal strength */
  int    *binomN,     /* number of trials for 'count' detector modelled with binomial */
  double *cut,        /* transformed signal strength threshold for detection */
  int    *spherical,
  double *a,          /* return value integral of pr(w0) */
  int    *resultcode  /* 0 for successful completion */
);

void secrloglik (
  int    *like,       /* likelihood 0 full, 1 conditional */
  int    *detect,     /* detector 0 multi, 1 proximity */
  int    *distrib,    /* distribution 0 Poisson, 1 binomial */
  int    *w,          /* capture histories (1:nc, 1:s, 1:k) */
  int    *grp,        /* group number for 0<=n<*nc   [full likelihood only] */
  int    *nc,         /* number of capture histories */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *mm,         /* number of points on mask */
  int    *gg,         /* number of groups */
  double *traps,      /* x,y locations of traps (first x, then y)  */
  double *mask,       /* x,y points on mask (first x, then y)  */
  double *Dmask,      /* density at each point on mask, possibly x group */
  double *gsbval,     /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) */
  double *gsb0val,    /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) [naive animal] */
  int    *cc,         /* number of g0/sigma/b combinations  */
  int    *cc0,        /* number of g0/sigma/b combinations for naive animals */
  int    *gsb,        /* lookup which g0/sigma/b combination to use for given n, S, K */
  int    *gsb0,       /* lookup which g0/sigma/b combination to use for given g, S, K [naive animal] */
  double *area,       /* area associated with each mask point (ha)  */
  int    *fn,         /* code 0 = halfnormal, 1 = hazard */
  int    *binomN,     /* number of trials for 'count' detector modelled with binomial */
  double *cut,        /* transformed signal strength threshold for detection */
  int    *spherical,
  double *minprob,    /* minimum value of P(detection history) added 2009 10 03 */   
  double *a,          /* a(theta)   */
  double *value,      /* return value integral of pr(w0) */
  int    *resultcode  /* return value 0 if OK */
);

void MRsecrloglik (
    int    *detect,      /* detector 0 multi, 1 proximity */
    int    *distrib,     /* distribution 0 Poisson, 1 binomial */
    int    *w,           /* capture histories (1:nc, 1:s, 1:k) */
    int    *Tu,          /* unmarked counts s = qq+1 ... ss, dim=c(*kk, *ss, *gg) */
    int    *Tm,          /* marked not ID counts s = qq+1 ... ss, dim=c(*kk, *ss, *gg) */
    int    *grp,         /* group number for 0<=n<*nc   [full likelihood only] */
    int    *nc,          /* number of capture histories */
    int    *ss,          /* total number of occasions */
    int    *qq,          /* number of marking occasions */
    int    *kk,          /* number of traps */
    int    *mm,          /* number of points on mask */
    int    *gg,          /* number of groups */
    double *traps,       /* x,y locations of traps (first x, then y) */
    double *mask,        /* x,y points on mask (first x, then y) */
    double *Dmask,       /* density at each point on mask, possibly x group */
    double *gsbval,      /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) */
    double *gsb0val,     /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) [naive animal] */
    int    *cc,          /* number of g0/sigma/b combinations  */
    int    *cc0,         /* number of g0/sigma/b combinations for naive animals */
    int    *gsb,         /* lookup which g0/sigma/b combination to use for given n, S, K */
    int    *gsb0,        /* lookup which g0/sigma/b combination to use for given g, S, K [naive animal] */
    double *pID,         /* Parameter value - probability marked animal identified on resighting */
    double *area,        /* area associated with each mask point (ha) */
    int    *fn,          /* code 0 = halfnormal, 1 = hazard rate, 2 = exponential */
    int    *binomN,      /* for count detector - not yet used 2009 10 08 */
    double *minprob,     /* minimum value of P(detection history) */
    double *value,       /* return value integral of pr(w0) */
    int    *resultcode   /* 0 if OK */
);

void trappingproximity (
  double *g0,         /* Parameter : detection magnitude */ 
  double *sigma,      /* Parameter : detection scale */
  double *z,          /* Parameter : detection shape (hazard) */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *N,          /* number of animals */
  double *animals,    /* x,y points of animal range centres (first x, then y)  */
  double *traps,      /* x,y locations of traps (first x, then y)  */
  int    *fn,         /* code 0 = halfnormal, 1 = hazard, 11 = normal signal */
  int    *n,          /* number of individuals caught */
  int    *caught,     /* caught in session */
  int    *value,      /* return value matrix of trap locations n x s */
  int    *resultcode
);

void simsecr (
  int    *detect,     /* detector 0 multi, 1 proximity */
  double *gsb0val,    /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) [naive animal] */
  double *gsb1val,    /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) [caught before] */
  int    *cc0,        /* number of g0/sigma/b combinations for naive animals */
  int    *cc1,        /* number of g0/sigma/b combinations for caught before */
  int    *gsb0,       /* lookup which g0/sigma/b combination to use for given g, S, K [naive animal] */
  int    *gsb1,       /* lookup which g0/sigma/b combination to use for given n, S, K [caught before] */
  int    *N,          /* number of animals */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  double *animals,    /* x,y points of animal range centres (first x, then y)  */
  double *traps,      /* x,y locations of traps (first x, then y)  */
  int    *used,       /* ss x kk array of 0/1 codes for usage */
  int    *Markov,     /* code 0 if behavioural response is learned, 1 if Markov */
  int    *binomN,     /* number of trials for 'count' detector modelled with binomial */
  double *area,       /* area of search cell associated with each detector   */
  int    *fn,         /* code 0 = halfnormal, 1 = hazard, 2 = exponential, 3 = uniform */
  int    *n,          /* number of individuals caught */
  int    *caught,     /* caught in session */
  int    *value,      /* return value array of trap locations n x s */
  int    *resultcode
);

void trappingarea (
  double *g0,         /* Parameter : detection magnitude */
  double *sigma,      /* Parameter : detection scale */
  double *z,          /* Parameter : detection shape (hazard) */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *N,          /* number of animals */
  double *animals,    /* x,y points of animal range centres (first x, then y)  */
  double *traps,      /* x,y locations of search cell centres (first x, then y)  */
  double *area,       /* area of search cell associated with each point */
  int    *fn,         /* code 0 = halfnormal, 1 = hazard, 11 = normal signal */
  int    *n,          /* number of individuals caught */
  int    *caught,     /* caught in session */
  int    *value,      /* return value matrix of trap locations n x s */
  int    *resultcode
);

void trappingsignal (
  double *beta0,      /* Parameter : intercept */
  double *beta1,      /* Parameter : slope */
  double *sdS,        /* Parameter : error sd */
  double *cut,        /* detection threshold on transformed scale */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *N,          /* number of animals */
  double *animals,    /* x,y points of animal range centres (first x, then y)  */
  double *traps,      /* x,y locations of traps (first x, then y)  */
  int    *fn,         /* code 10 = signal strength, 11 = binary signal strength */
  int    *spherical,
  int    *n,          /* number of individuals caught */
  int    *caught,     /* caught in session */
  double *value,      /* return value matrix of trap locations n x s */
  int    *resultcode
);

void trappingcount (
  double *g0,         /* Parameter : detection intercept */
  double *sigma,      /* Parameter : detection scale */
  double *z,          /* Parameter : detection shape (hazard) */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *N,          /* number of animals */
  double *animals,    /* x,y points of animal range centres (first x, then y)  */
  double *traps,      /* x,y locations of traps (first x, then y)  */
  int    *fn,         /* code 0 = halfnormal, 1 = hazard, 11 = normal signal */
  int    *binomN,     /* number of trials for 'count' detector modelled with binomial */
  int    *n,          /* number of individuals caught */
  int    *caught,     /* caught in session */
  int    *value,      /* return value matrix of trap locations n x s */
  int    *resultcode
);

void trappingmulti (
  double *g0,         /* Parameter : detection magnitude */
  double *sigma,      /* Parameter : detection scale */
  double *z,          /* Parameter : detection shape (hazard) */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *N,          /* number of animals */
  double *animals,    /* x,y points of animal range centres (first x, then y)  */
  double *traps,      /* x,y locations of traps (first x, then y)  */
  int    *fn,         /* code 0 = halfnormal, 1 = hazard, 2 = exponential */
  int    *n,          /* number of individuals caught */
  int    *caught,     /* caught in session */
  int    *value,      /* return value matrix of trap locations n x s */
  int    *resultcode  /* 0 for successful completion */
);

void trappingsingle (
  double *g0,         /* Parameter : detection magnitude */
  double *sigma,      /* Parameter : detection scale */
  double *b,          /* Parameter : detection shape (hazard) */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *N,          /* number of animals */
  double *animals,    /* x,y points of animal range centres (first x, then y)  */
  double *traps,      /* x,y locations of traps (first x, then y)  */
  int    *fn,         /* code 0 = halfnormal, 1 = hazard, 2 = exponential */
  int    *n,          /* number of individuals caught */
  int    *caught,     /* caught in session */
  int    *value,      /* return value matrix of trap locations n x s */
  int    *resultcode  /* 0 for successful completion */
);

void naived (
  double *sigma,      /* Parameter : detection scale */
  int    *kk,         /* number of traps */
  int    *nc,
  double *traps,      /* x,y locations of traps (first x, then y) */
  double *animals,    /* x,y locations of traps (first x, then y) */
  int    *fn,         /* code 0 = halfnormal ONLY */
  double *value       /* return value  */
);

void naivecap2 (
  int    *detect,     /* code 0 = multicatch, 1 = proximity */
  double *g0,         /* Parameter : detection magnitude */
  double *sigma,      /* Parameter : detection scale */
  int    *ss,         /* number of occasions */
  int    *kk,         /* number of traps */
  int    *mm,
  double *traps,      /* x,y locations of traps (first x, then y) */
  double *mask,       /* x,y points on mask (first x, then y) */
  int    *fn,         /* code 0 = halfnormal ONLY */
  double *value       /* return value  */
);

void makelookup (   
  double *x,            /* input matrix */
  int    *nrow,         /* input */
  int    *ncol,         /* input */
  int    *unique,       /* output number of unique rows */
  double *y,            /* output matrix of unique rows (byrow=T) */
  int    *index,        /* output lookup rows of x in y */
  int    *resultcode    /* zero if OK */
);

void nearest (   
  double *xy,         /* input point */
  int    *ntrap,      /* input */
  double *traps,      /* input */
  int    *p,          /* output index of nearest point */
  double *d           /* output distance to nearest point */
);

void inside (double *xy, int *np, double *poly, int *in);

void secrcellprob (
    int    *detect,      /* detector 0 multi, 1 proximity */
    int    *w,           /* capture histories (1:nc, 1:s, 1:k) */
    int    *grp,         /* group number for 0<=n<*nc   [full likelihood only] */
    int    *nc,          /* number of capture histories */
    int    *ss,          /* number of occasions */
    int    *kk,          /* number of traps */
    int    *mm,          /* number of points on mask */
    int    *gg,          /* number of groups */
    double *traps,       /* x,y locations of traps (first x, then y) */
    double *mask,        /* x,y points on mask (first x, then y) */
    double *Dmask,       /* density at each point on mask, possibly x group */
    double *gsbval,      /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) */
    double *gsb0val,     /* Parameter values (matrix nr= comb of g0,sigma,b nc=3) [naive animal] */
    int    *cc,          /* number of g0/sigma/b combinations  */
    int    *cc0,         /* number of g0/sigma/b combinations for naive animals */
    int    *gsb,         /* lookup which g0/sigma/b combination to use for given n, S, K */
    int    *gsb0,        /* lookup which g0/sigma/b combination to use for given g, S, K [naive animal] */
    double *area,        /* area associated with each mask point (ha) */
    int    *fn,          /* code 0 = halfnormal, 1 = hazard, 2 = exponential */
    int    *binomN,      /* number of trials for 'count' detector modelled with binomial */
    double *cut,         /* transformed signal strength threshold for detection */
    int    *spherical,
    double *minprob,     /* minimum value of P(detection history) added 2009 10 03 */   
    double *value,       /* return value integral of pr(w0) */
    int    *resultcode   /* 0 if OK */
);
