### Name: ovenbird
### Title: Ovenbird Mist-netting Dataset
### Aliases: ovenbird ovenCH ovenbird.model.1 ovenbird.model.1b
### Keywords: datasets

### ** Examples


## Not run: 
##D 
##D ## commands used to create ovenCH from the input files
##D ## 'netsites0509.txt' and 'ovencapt.txt' 
##D ## for information only - these files not distributed
##D netsites0509 <- read.traps(file = 'netsites0509.txt',
##D     skip = 1, detector = 'multi')
##D temp <- read.captures('ovencapt.txt', colClasses=c('character',
##D     'character', 'numeric', 'numeric', 'character'))
##D ovenCH <- make.capthist(temp, netsites0509, covnames=c('Sex','Age'))
##D 
## End(Not run)

require (graphics)
data(ovenbird)
par(mfrow = c(1,5), mar = c(1,1,4,1))
plot(ovenCH, tracks = TRUE, varycol = TRUE)

counts(ovenCH, 'n')

## Not run: 
##D 
##D ## array constant over years, so build mask only once
##D ovenmask <- make.mask(traps(ovenCH)[['2005']], type='pdot', buffer=400, 
##D     spacing=15, detectpar=list(g0=0.03, sigma=90), nocc=10)
##D 
##D ## fit constant-density model
##D ovenbird.model.1 <- secr.fit(ovenCH, mask = ovenmask)
##D ovenbird.model.1
##D 
##D ## fit net avoidance model
##D ovenbird.model.1b <- secr.fit(ovenCH, mask = ovenmask, model =
##D     list(g0~b))
##D ovenbird.model.1b
##D 
## End(Not run)

## compare & average pre-fitted models
AIC(ovenbird.model.1, ovenbird.model.1b)
model.average(ovenbird.model.1, ovenbird.model.1b)

## select one year to plot
plot(ovenbird.model.1b, newdata = data.frame(session = '2005', 
    b = 0))




