### Name: rbind.capthist
### Title: Combine capthist Objects
### Aliases: rbind.capthist MS.capthist
### Keywords: manip

### ** Examples


## simulate 2-part mixture
temptrap <- make.grid(nx = 8, ny = 8)
temp1 <- sim.capthist(temptrap, 
    detectpar = list(g0 = 0.1, sigma = 40))
temp2 <- sim.capthist(temptrap, 
    detectpar = list(g0 = 0.2, sigma = 20))
temp3 <- rbind.capthist(temp1, temp2)

## compare mixture to sum of components
## note 'traps visited' is not additive for 'multi' detector
## nor is 'traps set'
(summary(temp1)$counts +  summary(temp2)$counts) -
    summary(temp3)$counts



