###################################################
### chunk number 1: 
###################################################
library(secr)
par(mfrow=c(1,1), pty='s', mar=c(2,2,2,2), cex=1.2)
plot(sim.popn(D=5, core=make.grid(), buffer=150), cex=1.2)
plot(make.grid(),add=T, detpar=list(col = "red", pch = 3, cex = 1.2))


###################################################
### chunk number 2: 
###################################################
par(mfrow=c(1,1), pty='s', mar=c(4,4,2,2), las=1, bty='l', xpd=T)
detectfnplot (detectfn = 0, pars=c(0.4, 30), xval=0:120, ylim=c(0,0.45), cex=1.3, lwd=2)
detectfnplot (detectfn = 1, pars=c(0.4, 50, 5), xval=0:120, add=T, cex=1.2, col='blue', lwd=2)
detectfnplot (detectfn = 2, pars=c(0.4, 30), xval=0:120, add = T, cex=1.2, col='green', lwd=2)
legend (68,0.45, lwd=2, col=c('blue', 'black','green'), cex=1.2,
    legend=c('hazard-rate','halfnormal','exponential'), bty='n')


###################################################
### chunk number 3:  eval=FALSE
###################################################
## RShowDoc ('secr-manual', package='secr')


###################################################
### chunk number 4: 
###################################################
vignette()


###################################################
### chunk number 5:  eval=FALSE
###################################################
## vignette('sound')


###################################################
### chunk number 6: 
###################################################
options(continue=" ")
options(width=70)


###################################################
### chunk number 7: 
###################################################
library(secr)                                       # load library
mytraps <- make.grid(nx = 10, ny = 10,              # build detector array
    spacing = 30, originxy = c(365,365))
mycapt <- read.captures (file = 'capt.txt')         # import capture data
myCH <- make.capthist (mycapt, mytraps, fmt='XY')   # build capthist object



###################################################
### chunk number 8: 
###################################################
secr0 <- secr.fit(myCH, model = g0~1, trace = FALSE) # null model
secrb <- secr.fit(myCH, model = g0~b, trace = FALSE) # trap response model
AIC (secr0, secrb)                                   # compare


###################################################
### chunk number 9: 
###################################################
secr0                                                # display estimates


