###################################################
### chunk number 1: 
###################################################
library(secr)
data(ovensong)
summary(signalCH)


###################################################
### chunk number 2: 
###################################################
signalCH.525 <- subset(signalCH, cutval = 52.5)
summary(signalCH.525)


###################################################
### chunk number 3: 
###################################################
traps(signalCH.525)


###################################################
### chunk number 4: 
###################################################
temp <- signalCH.525[,1,]
temp[temp>0] <- round(signal(signalCH.525),1)
temp[1:8,]


###################################################
### chunk number 5: 
###################################################
omask <- make.mask(traps(signalCH), buffer = 200)
ostart <- c(log(20), 80, log(0.1), log(2))
sound.1 <- secr.fit(signalCH.525, mask = omask, start = ostart,
                          details = list(trace = FALSE))


###################################################
### chunk number 6: 
###################################################
sound.1


###################################################
### chunk number 7: 
###################################################
sound.2 <- secr.fit(signalCH.525, detectfn = 11,
                    mask = omask, start = ostart,
                    details = list(trace = FALSE))


###################################################
### chunk number 8: 
###################################################
AIC (sound.1, sound.2)


###################################################
### chunk number 9: 
###################################################
collate(sound.1, sound.2)[1,,,'D']/75


###################################################
### chunk number 10: 
###################################################
pars1 <- predict(sound.1)[c('beta0', 'beta1'), 'estimate']
pars2 <- predict(sound.2)[c('beta0', 'beta1'), 'estimate']
attenuationplot(pars1, xval=0:150, spherical = FALSE, ylim = c(40,110))
attenuationplot(pars2, xval=0:150, spherical = TRUE, add = TRUE, col = 'red')
pars2[2] <- 0
attenuationplot(pars2, xval=0:150, spherical = TRUE, add = TRUE, lty = 2)


###################################################
### chunk number 11:  eval=FALSE
###################################################
## plot(sound.2, col = 'red')
## 


###################################################
### chunk number 12: 
###################################################

beta0 <- seq(99, 107, 0.25)
beta1 <- seq(-0.135, -0.085, 0.00125)
LL <- LLsurface.secr(sound.2, betapar=c('beta0','beta1'),
           xval = beta0, yval = beta1, plot = FALSE)
image(LL, x = beta0, y = beta1,  breaks = c(-510, seq(-500, -460, 2)),
       col = topo.colors(21))
contour(LL, x = beta0, y = beta1, add = TRUE, levels = seq(-510, -460, 0.5),
       drawlabels = FALSE)
points(103.77, -exp(-2.169), pch=16)
points(100.73, -exp(-2.339), pch=2)



