### Name: plot.mask
### Title: Plot Habitat Mask
### Aliases: plot.mask
### Keywords: hplot

### ** Examples


# simple

temptrap <- make.grid()
tempmask <- make.mask(temptrap)
plot (tempmask)

## restrict to points over an arbitrary detection threshold,
## add covariate, plot image and overlay traps

tempmask <- subset(tempmask, pdot(tempmask,temptrap)>0.001)

covariates (tempmask) <- data.frame(circle = 
    exp(-(tempmask$x^2 + tempmask$y^2)/10000) )

plot (tempmask, covariate = 'circle', dots = FALSE, axes = TRUE, 
    add = TRUE, col = terrain.colors(256))
plot (temptrap, add = TRUE)

## add a legend

par(cex = 0.9)
covrange <- range(covariates(tempmask)$circle)
step <- diff(covrange)/8
colourlev <- terrain.colors(256)[seq(1,256,(256-1)/8)]
zlev <- formatC(seq(covrange[1],covrange[2],step), format='f', 
    digits=2, width=4)
legend (x = 'topright', fill = colourlev, legend = zlev, 
    y.intersp = 0.8, title = 'Covariate')

title('Colour mask points with p.(X) > 0.001')
mtext(side=3,line=-1, 'g0 = 0.2, sigma = 20, nocc = 5')




