### Name: possum
### Title: Brushtail Possum Trapping Dataset
### Aliases: possum possumCH possummask possum.model.1 possum.model.1b
### Keywords: datasets

### ** Examples


## Not run: 
##D 
##D setwd('d:\density communication\webtest\foxton\')
##D possumtraps <- read.traps(file = 'foxtraps.txt', detector = 'single')
##D temp <- read.captures('foxton.txt', colClasses=c('character',
##D     'character', 'numeric', 'character'))
##D ## drop within-day duplicates of animal 5861
##D temp <- temp[-c(184,186),]
##D 
##D possumCH <- make.capthist(temp, possumtraps)
##D possummask <- make.mask(possumtraps, buffer = 300, type='pdot', pdotmin = 0.001,
##D     detectpar = list(g0=0.2, sigma=60), spacing = 10)
##D 
##D ## fit constant-density model
##D possum.model.1 <- secr.fit(possumCH, mask = possummask)
##D ## fit learned trap response model
##D possum.model.1b <- secr.fit(possumCH, mask = possummask, model = list(g0~b))
##D 
## End(Not run)

require (graphics)
data(possum)
plot(possummask)
plot(possumCH, tracks = TRUE, add = TRUE)
plot(traps(possumCH), add = TRUE)
summary(possumCH)

## compare & average pre-fitted models
AIC(possum.model.1, possum.model.1b)
model.average(possum.model.1, possum.model.1b)




