### Name: sim.popn
### Title: Simulate 2-D Population
### Aliases: sim.popn
### Keywords: datagen

### ** Examples


temppop <- sim.popn (D = 10, expand.grid(x = c(0,100), y = 
    c(0,100)), buffer = 50)

## plot, distinguishing 'M' and 'F'
plot(temppop, pch = 1, cex= 1.5,
    col = c('green','red')[covariates(temppop)$sex])

## add a continuous covariate
## assumes covariates(temppop) is non-null
covariates(temppop)$size <- rnorm (nrow(temppop), mean = 15, sd = 3)
summary(covariates(temppop))

## Neyman-Scott cluster distribution
oldpar <- par(xpd = TRUE, mfrow=c(2,3))
for (h in c(5,15))
for (m in c(1,4,16)) {
    temppop <- sim.popn (D = 10, expand.grid(x = c(0,100),
        y = c(0,100)), model2D = 'cluster', buffer = 100,
        details = list(mu = m, hsigma = h))
    plot(temppop)
    text (50,230,paste(' mu =',m, 'hsigma =',h))
}
par(oldpar)

## Inhomogeneous Poisson distribution
data(secrdemo)
xy <- secrdemo.0$mask$x + secrdemo.0$mask$y - 900
tempD <- xy^2 / 1000
plot(sim.popn(tempD, secrdemo.0$mask, model2D = 'IHP'))




