### Name: subset.capthist
### Title: Subset or Split capthist Object
### Aliases: subset.capthist split.capthist
### Keywords: manip

### ** Examples

tempcapt <- sim.capthist (make.grid(nx=6, ny=6), nocc=6)
summary(subset(tempcapt, occ=c(1,3,5)))

## Consider 'proximity' detections at a random subset of detectors
## This would not make sense for 'multi' detectors, as the 
## excluded detectors influence detection probabilities in 
## sim.capthist.

tempcapt2 <- sim.capthist (make.grid(nx = 6, ny = 6, 
    detector = 'proximity'), nocc = 6)
tempcapt3 <- subset(tempcapt2, traps = sample(1:36, 18, 
    replace=FALSE))
summary(tempcapt3)
plot(tempcapt3)

split (tempcapt2, f = sample (c('A','B'), nrow(tempcapt2), 
    replace = TRUE))




