secr.design.MS             package:secr             R Documentation

_C_o_n_s_t_r_u_c_t _D_e_t_e_c_t_i_o_n _M_o_d_e_l _D_e_s_i_g_n _M_a_t_r_i_c_e_s _a_n_d _L_o_o_k_u_p_s

_D_e_s_c_r_i_p_t_i_o_n:

     Internal function used by 'secr.fit'.

_U_s_a_g_e:

     secr.design.MS(capthist, models, timecov = NULL, sessioncov = NULL, 
         groups = NULL, dframe = NULL, naive = FALSE, bygroup = FALSE, ...)

_A_r_g_u_m_e_n_t_s:

capthist: 'capthist' object 

  models: list of formulae for parameters of detection 

 timecov: optional dataframe of values of time (occasion-specific)
          covariate(s). 

sessioncov: optional dataframe of values of session-specific
          covariate(s). 

  groups: optional vector of one or more variables with which to form
          groups. Each element should be the name of a factor variable
          in the 'covariates' attribute of 'capthist'. 

  dframe: optional data frame of design data for detection parameters 

   naive: logical if TRUE then modelled detection probability is for a
          naive animal (not caught previously); if FALSE then detection
          probability is contingent on individual's history of
          detection 

 bygroup: logical if TRUE then the individual dimension of the
          parameter matrix is automatically collapsed to one row per
          group; if FALSE then the full dimensionality is retained (one
          row per individual) 

     ...: other arguments passed to the R function 'model.matrix' 

_D_e_t_a_i_l_s:

     This is an internal 'secr' function that you are unlikely ever to
     use. ... may be used to pass 'contrasts.arg' to 'model.matrix'. 

     Each real parameter is notionally different for each unique
     combination of session, individual, occasion and detector, i.e.,
     for R sessions, n individuals, S occasions and K detectors there
     are _potentially_ R x n x S x K different values. Actual models
     always predict a much reduced set of distinct values, and the
     number of rows in the design matrix is reduced correspondingly; a
     parameter index array allows these to retrieved for any
     combination of session, individual, occasion and detector.

_V_a_l_u_e:

     A list with the components  

designMatrices: list of reduced design matrices, one for each real
          detection parameter 

parameterTable: index to row of the reduced design matrix for each real
          detection parameter; dim(parameterTable) = c(uniquepar, np),
          where uniquepar is the number of unique combinations of
          paramater values (uniquepar < RnSK) and np is the number of
          parameters in the detection model. 

     PIA: Parameter Index Array - index to row of parameterTable for a
          given session, animal, occasion and detector; dim(PIA) =
          c(R,n,S,K) 

_A_u_t_h_o_r(_s):

     Murray Efford murray.efford@otago.ac.nz

_S_e_e _A_l_s_o:

     'D.designdata'

_E_x_a_m_p_l_e_s:

     data(captdata)
     secr.design.MS (captdata, models = list(g0 = ~b))$designMatrices
     secr.design.MS (captdata, models = list(g0 = ~b))$parameterTable

